/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.building;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class HireFireMessage
extends AbstractBuildingServerMessage<IBuildingWorker> {
    private boolean hire;
    private int citizenID;

    public HireFireMessage() {
    }

    public HireFireMessage(@NotNull AbstractBuildingView building, boolean hire, int citizenID) {
        super(building);
        this.hire = hire;
        this.citizenID = citizenID;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.hire = buf.readBoolean();
        this.citizenID = buf.readInt();
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.writeBoolean(this.hire);
        buf.writeInt(this.citizenID);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuildingWorker building) {
        ICitizenData citizen = colony.getCitizenManager().getCivilian(this.citizenID);
        citizen.setPaused(false);
        if (this.hire) {
            building.assignCitizen(citizen);
        } else {
            building.removeCitizen(citizen);
        }
    }
}

